***************************
*** After the Uprisings ***
***************************

use "Arab Barometer IRT.dta", replace

gen ctyname = ""
replace ctyname = "Algeria" if country == 1
replace ctyname = "Egypt" if country == 5
replace ctyname = "Iraq" if country == 7
replace ctyname = "Jordan" if country == 8
replace ctyname = "Lebanon" if country == 10
replace ctyname = "Palestine" if country == 15
replace ctyname = "Sudan" if country == 19
replace ctyname = "Tunisia" if country == 21
replace ctyname = "Yemen" if country == 22

recode q2011 (1=4) (2=3) (3=2) (4=1) (0=.) (8/.=.), gen(trustgov)

*A political system governed by a strong authority which makes decisions without considering electoral results or the opinions of the opposition.
recode q5183 (1=4) (2=3) (3=2) (4=1) (0=.) (8/.=.), gen(authoritarianism)

*A system governed by Islamic law without elections or political parties.
recode q5184 (1=4) (2=3) (3=2) (4=1) (0=.) (8/.=.), gen(theocracy)

gen treated = 0
replace treated = 1 if inlist(country, 5, 21, 22)

keep authoritarianism theocracy trustgov irtsupport sharia religious trust membership education protest ///
	econperformance govtperformance demoseffective2 female age working polity ///
	gdppc gdpgrowth unemployment logpop ctyname wave wt treated country

collapse authoritarianism theocracy trustgov irtsupport sharia religious trust membership education ///
	protest econperformance govtperformance demoseffective2 female age working ///
	polity gdppc gdpgrowth unemployment logpop treated country [pweight=wt], by(ctyname wave)


outsheet using synthetic.csv, comma nolab replace
